@extends('layouts.admin.home')

<!-- title page -->
@section('title')
    <title>Wallets</title>
@endsection

<!-- custom css -->
@section('css')
<style>
    .select2-container[dir="rtl"] .select2-selection--single .select2-selection__rendered {
        padding-right: 200px;
    }
</style>
@endsection

@section('content')

    <div class="page-content">
        <div class="container-fluid">

            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent" style="direction: ltr;">
                        {{-- <h4 class="mb-sm-0">Team</h4> --}}

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"></li>
                                <li class="breadcrumb-item"><a href="{{route('admin/index')}}">Home</a></li>
                                <li class="breadcrumb-item active"><a href="{{route('admin/wallets/index')}}/0/{{PAGINATION_COUNT}}">Wallets</a></li>
                                <li class="active" style="color: var(--vz-breadcrumb-item-active-color);">Index</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>

            @include('flash::message')
            @if ($errors->any())
                <div style="text-align: left; margin: 15px;">
                    <ul dir="ltr">
                        @foreach ($errors->all() as $error)
                            <li class="text-danger">{{$error}}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Wallets Viwes</h5>
                        </div>
                        <div class="card-body">
                            <div id="scroll-horizontal_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
                                <div class="row" style="direction: ltr;">
                                    <div class="col-sm-12 col-md-12">
                                        <div id="scroll-horizontal_filter" class="dataTables_filter">
                                            {{-- <label>
                                                <input type="search" class="form-control form-control-sm data_search" placeholder="Search" aria-controls="scroll-horizontal" />
                                            </label> --}}
                                            <form role="form" action="{{route('admin/wallets/index')}}/0/{{PAGINATION_COUNT}}" method="get" class="d-flex justify-content-start">
                                                {{ csrf_field() }}
                                                <label>
                                                    <div class="col-xxl-12 col-md-12">
                                                        <div class="form-group">
                                                            <label style="margin-bottom: 7px;" for="">User <span class="text-danger"></span></label><br/>
                                                            <select name="user_id" id="users" class="form-control">
                                                                <option value="">---</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </label>
                                                <label>
                                                    <div class="col-xxl-12 col-md-12 m-2 mt-0">
                                                        <div class="form-group">
                                                            <label style="margin-bottom: 7px;" for="">Group <span class="text-danger"></span></label><br/>
                                                            <select name="group_id" id="groups" class="form-control">
                                                                <option value="">---</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </label>
                                                <label style="margin-top: 22px; margin-left: 12px;">
                                                    <div class="col-xs-12">
                                                        <div class="modal-footer">
                                                            <button style="font-size: smaller;" class="btn btn-primary" type="submit">Search</button>
                                                        </div>
                                                    </div>
                                                </label>
                                                <label style="margin-top: 22px; margin-left: 3px;">
                                                    <div class="col-xs-12">
                                                        <button style="font-size: smaller;" type="reset" id="resetFillterForm" class="btn btn-info">Reset</button>
                                                    </div>
                                                </label>
                                            </form>
                                            
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="dataTables_scroll">
                                            <div class="dataTables_scrollBody" style="position: relative; overflow: auto; width: 100%">
                                                <table id="scroll-horizontal" class="table nowrap align-middle dataTable no-footer" style="width: 100%" aria-describedby="scroll-horizontal_info">
                                                    <thead>
                                                        <tr>
                                                            <th class="text-center">ID</th>
                                                            <th class="text-center">Wallet For</th>
                                                            <th class="text-center">For Type</th>
                                                            <th class="text-center">Added By</th>
                                                            <th class="text-center">Balance</th>
                                                            <th class="text-center">Actions</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody id="tableShowData">
                                                        @isset($wallets)
                                                            @foreach($wallets as $record)
                                                                <!-- $wallet -->
                                                                <tr class="text-center">
                                                                    <td class="text-center">{{$record->id}}</td>
                                                                    <td class="text-center">{{ $record->typeable?->name }}</td>
                                                                    <td class="text-center">@if((int)$record->typeable_id > 0) {{  $record->typeable_type == "App\Models\User" ? 'User' : 'Group' }} @endif</td>
                                                                    <td class="text-center">{{$record->typeable?->added_by?->name}}</td>
                                                                    <td class="text-center">{{$record->balance}}</td>
                                                                    <td class="text-center">
                                                                        <div class="dropdown d-inline-block">
                                                                            <button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                                                <i class="ri-more-fill align-middle"></i>
                                                                            </button>
                                                                            <ul class="dropdown-menu dropdown-menu-end" style="text-align: end;">
                                                                                <li>
                                                                                    <button class="dropdown-item edit-item-btn openActivationFrom" data-bs-toggle="modal" data-bs-target="#myModalActivation-{{ $record->id }}" data-id="{{$record->id}}">
                                                                                        <i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Transactions
                                                                                    </button>
                                                                                </li>
                                                                            </ul>
                                                                        </div>
                                                                        <div class="modal fade" id="myModalActivation-{{ $record->id }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                                            <div class="modal-dialog modal-xl" role="document" style="width: 80%">
                                                                                <div class="modal-content">
                                                                                    <div class="modal-header">
                                                                                        <h5 class="modal-title f-w-600" id="exampleModalLabel"></h5>
                                                                                    </div>
                                                                                    <div class="modal-body text-center p-5">
        
                                                                                        <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
                                                                                            <div class="modal-content">
                                                                                                <div class="modal-header bg-primary text-white">
                                                                                                    <h5 class="modal-title text-center w-100" style="color: white; padding-bottom: 12px;">
                                                                                                        المعاملات المالية الخاصه ل : @if((int)$record->typeable_id > 0) {{  $record->typeable_type == "App\Models\User" ? 'user -> ' : 'group -> ' }} @endif {{$record->typeable?->name}}
                                                                                                    </h5>
                                                                                                </div>
                                                                                        
                                                                                                <div class="modal-body text-center p-4">
                                                                                                    <table class="table table-bordered table-striped table-hover text-center align-middle">
                                                                                                        <thead class="table-dark">
                                                                                                            <tr>
                                                                                                                <th>#</th>
                                                                                                                <th>User</th>
                                                                                                                <th>Amount</th>
                                                                                                                <th>Type</th>
                                                                                                                <th>Status</th>
                                                                                                                <th>Description</th>
                                                                                                                <th>Action</th>
                                                                                                            </tr>
                                                                                                        </thead>
                                                                                                        <tbody>
                                                                                                            @isset($record->transactions)
                                                                                                                @foreach($record->transactions as $transaction)
                                                                                                                    <tr>
                                                                                                                        <th>{{ $transaction->id }}</th>
                                                                                                                        <td>{{ $transaction->user?->name }}</td>
                                                                                                                        <td>{{ number_format($transaction->amount, 2) }}</td>
                                                                                                                        <td>
                                                                                                                            <span class="badge bg-success">
                                                                                                                                {{ $transaction->type == 1 ? 'Deposit' : 'Withdraw' }}
                                                                                                                            </span>
                                                                                                                        </td>
                                                                                                                        <td>
                                                                                                                            <span class="badge {{ $transaction->status == 1 ? 'bg-primary' : 'bg-warning text-dark' }}">
                                                                                                                                {{ $transaction->status == 1 ? 'Completed' : 'Not Completed' }}
                                                                                                                            </span>
                                                                                                                        </td>
                                                                                                                        <td>{{ $transaction->description }}</td>
                                                                                                                        <td class="text-center">
                                                                                                                            <div class="dropdown d-inline-block">
                                                                                                                                <button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                                                                                                    <i class="ri-more-fill align-middle"></i>
                                                                                                                                </button>
                                                                                                                                <ul class="dropdown-menu dropdown-menu-end" style="text-align: end;">
                                                                                                                                    @if ($transaction->type == 2 && $transaction->status == 0)
                                                                                                                                        <li>
                                                                                                                                            <a onclick="return confirm('متأكد إنك عايز تأكد العملية؟');" href="{{route('admin/wallets/confirm-withdraw', $transaction->id)}}" class="dropdown-item edit-item-btn">
                                                                                                                                                <i class="ri-pencil-fill align-bottom me-2 text-muted"></i> confirm
                                                                                                                                            </a>
                                                                                                                                        </li>
                                                                                                                                    @endif
                                                                                                                                </ul>
                                                                                                                            </div>
                                                                                                                        </td>
                                                                                                                    </tr>
                                                                                                                @endforeach
                                                                                                            @endisset
                                                                                                        </tbody>
                                                                                                    </table>
                                                                                                </div>
                                                                                            </div>
                                                                                        </div>
                                                                                        
                                                                                        
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                                
                                                            @endforeach
                                                        @endisset
                                                    </tbody>
                                                </table>

                                                {{-- <div style="margin-top: 20px; font-weight: 600; font-size: 16px;">
                                                    Showing 1 to <span id="showItems"></span> of <span>{{App\Models\Wallet::unArchive()->count()}}</span> entries
                                                </div> --}}
                                                <div class="ltn__pagination-area text-center mt-5">
                                                
                                                    {{-- <div class="ltn__pagination text-center">
                                                        <div id="load_more">
                                                            <button type="button" name="load_more_button" style="width: 350px;" class="btn btn-info form-control px-5" data-id="'.$last_id.'" id="load_more_button">عرض المزيد</button>
                                                        </div>
                                                    </div> --}}
                                
                                                    {{-- pagination are --}}
                                                    <div class="d-flex justify-content-center mt-2">
                                                        <div class="d-flex justify-content-center mt-2">
                                                            <nav aria-label="Page navigation">
                                                                <ul class="pagination flex-wrap justify-content-center" style="align-items: center;">
                                                                    <!-- Previous Button -->
                                                                    @if (!$wallets->onFirstPage())
                                                                        <li class="page-item mt-1">
                                                                            <a class="page-link" href="{{ $wallets->previousPageUrl() }}"
                                                                            aria-label="Previous">
                                                                                <span aria-hidden="true">&laquo;</span>
                                                                            </a>
                                                                        </li>
                                                                    @endif
                                                    
                                                                    <!-- Pagination Numbers -->
                                                                    @for ($i = 1; $i <= $wallets->lastPage(); $i++)
                                                                        <li class="page-item mt-1 {{ $i == $wallets->currentPage() ? 'active' : '' }}">
                                                                            <a class="page-link" href="{{ $wallets->url($i) }}"
                                                                            @if ($i == $wallets->currentPage()) style="font-weight:bold;" @endif>
                                                                                {{ $i }}
                                                                            </a>
                                                                        </li>
                                                                    @endfor
                                                    
                                                                    <!-- Next Button -->
                                                                    @if ($wallets->hasMorePages())
                                                                        <li class="page-item mt-1">
                                                                            <a class="page-link" href="{{ $wallets->nextPageUrl() }}" aria-label="Next">
                                                                                <span aria-hidden="true">&raquo;</span>
                                                                            </a>
                                                                        </li>
                                                                    @endif
                                                                </ul>
                                                            </nav>
                                                        </div>
                                                    </div>

                                                </div>
                                                
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

@endsection

<!-- custom js -->
@section('script')
    <script>
        (function () {
            $('.nav-link.menu-link').removeClass('active');
            $('.menu-dropdown').removeClass('show');
            $('.sidebarwallets').addClass('active');
            var target = $('.sidebarwallets').attr('href');
            $(target).addClass('show');
        })();
        $(document).on('click', '.openDeleteFrom', function() {
            var id = $(this).attr('data-id');
            $('#delete_record_id').val(id);
        });
        $(document).on('click', '.openActivationFrom', function() {
            var id = $(this).attr('data-id');
            $('#activation_record_id').val(id);
        });
        $(document).on('click', '#resetFillterForm', function() {
            window.location.href = `{{route('admin/wallets/index')}}/0/{{PAGINATION_COUNT}}`;
        });
        $('#users').select2({
            ajax: {
                url: "{{ route('get/users') }}",
                dataType: 'json',
                processResults: function (data) {
                    return {
                        results:  $.map(data, function (item) {
                            return {
                                id: item.id,
                                text: item.name
                            }
                        })
                    };
                },
                cache: true,
                width: '100%'
            }
        });
        $('#groups').select2({
            ajax: {
                url: "{{ route('get/groups') }}",
                dataType: 'json',
                processResults: function (data) {
                    return {
                        results:  $.map(data, function (item) {
                            return {
                                id: item.id,
                                text: item.name
                            }
                        })
                    };
                },
                cache: true,
                width: '100%'
            }
        });
    </script>
@endsection
