@extends('layouts.admin.home')

<!-- title page -->
@section('title')
    <title>Cars</title>
@endsection

<!-- custom css -->
@section('css')
@endsection

@section('content')

    <div class="page-content">
        <div class="container-fluid">

            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent" style="direction: ltr;">
                        {{-- <h4 class="mb-sm-0">Team</h4> --}}

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"></li>
                                <li class="breadcrumb-item"><a href="{{route('admin/index')}}">Home</a></li>
                                <li class="breadcrumb-item active"><a href="{{route('admin/cars/index')}}/0/{{PAGINATION_COUNT}}">Cars</a></li>
                                <li class="active" style="color: var(--vz-breadcrumb-item-active-color);">Update</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>

            @include('flash::message')
            @if ($errors->any())
                <div style="text-align: left; margin: 15px;">
                    <ul dir="ltr">
                        @foreach ($errors->all() as $error)
                            <li class="text-danger">{{$error}}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header align-items-center d-flex">
                            <h4 class="card-title mb-0 flex-grow-1">Car Update</h4>
                        </div>
                        <div class="card-body">
                            @isset($car)
                                <form role="form" action="{{url(route('admin/cars/update', $car->id))}}" method="post" enctype="multipart/form-data">
                                    <div class="live-preview">
                                        @csrf
                                        <div class="row gy-4">

                                            <div class="card mt-xxl-n5">
                                                <div class="card-header">
                                                    <ul class="nav nav-tabs card-header-tabs" role="tablist">
                                                        <li class="nav-item">
                                                            <a class="nav-link active fw-bold" data-bs-toggle="tab" href="#enLang" role="tab" style="border-width: 4px;">
                                                                <span class="text-danger">*</span> البيانات الاساسيه (EN)
                                                            </a>
                                                        </li>
                                                        <li class="nav-item">
                                                            <a class="nav-link fw-bold" data-bs-toggle="tab" href="#arLang" role="tab" style="border-width: 4px;">
                                                                AR
                                                            </a>
                                                        </li>
                                                        <li class="nav-item">
                                                            <a class="nav-link fw-bold" data-bs-toggle="tab" href="#frLang" role="tab" style="border-width: 4px;">
                                                                FR
                                                            </a>
                                                        </li>
                                                        <li class="nav-item">
                                                            <a class="nav-link fw-bold" data-bs-toggle="tab" href="#trLang" role="tab" style="border-width: 4px;">
                                                                TR
                                                            </a>
                                                        </li>
                                                        <li class="nav-item">
                                                            <a class="nav-link fw-bold" data-bs-toggle="tab" href="#hiLang" role="tab" style="border-width: 4px;">
                                                                HI
                                                            </a>
                                                        </li>
                                                        <li class="nav-item">
                                                            <a class="nav-link fw-bold" data-bs-toggle="tab" href="#attributes" role="tab" style="border-width: 4px;">
                                                                Attributes
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            

                                                <div class="card-body p-4">
                                                    <div class="tab-content">
                                                        
                                                        <div class="tab-pane active" id="enLang" role="tabpanel">
                                                            <div class="row">
                                                                <div class="col-xxl-6 col-md-6 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput">name en <span class="text-danger">*</span></label>
                                                                        <input name="name[en]" value="{{ $car->translate('en')->name ?? '' }}" type="text" class="form-control" id="namefloatingInput" placeholder="name en">
                                                                    </div>
                                                                </div>
                                                                <div class="col-xxl-6 col-md-6 mb-3"></div>
                                                                
                                                                <div class="col-xxl-6 col-md-6">
                                                                    <div class="form-group">
                                                                        <label style="margin-bottom: 7px;" for="">المالك <span class="text-danger">*</span></label><br/>
                                                                        <select name="owner_id" id="users" class="form-control">
                                                                            <option value="{{ $car->owner_id }}">{{ $car->owner?->name }}</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-xxl-6 col-md-6">
                                                                    <div class="form-group">
                                                                        <label style="margin-bottom: 7px;" for="">السائق <span class="text-danger">*</span></label><br/>
                                                                        <select name="captain_id" id="captains" class="form-control">
                                                                            <option value="{{ $car->captain_id }}">{{ $car->captain?->name ?? '---' }}</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                {{-- <div class="col-xxl-6 col-md-6 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="mobilefloatingInput">mobile <span class="text-danger">*</span></label>
                                                                        <input name="mobile" value="{{ $car->mobile }}" type="text" class="form-control" id="mobilefloatingInput" placeholder="mobile">
                                                                    </div>
                                                                </div> --}}
                                                                <div class="col-xxl-6 col-md-6 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="pricefloatingInput">price <span class="text-danger">*</span></label>
                                                                        <input name="price" value="{{ $car->price }}" type="number" class="form-control" id="pricefloatingInput" placeholder="price">
                                                                    </div>
                                                                </div>
                                                                {{-- <div class="col-xxl-6 col-md-6 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="offerfloatingInput">offer <span class="text-danger"></span></label>
                                                                        <input name="offer" value="{{ $car->offer }}" type="number" class="form-control" id="offerfloatingInput" placeholder="offer">
                                                                    </div>
                                                                </div> --}}
                                                                <div class="col-xxl-6 col-md-6 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="persons_countfloatingInput">person count <span class="text-danger">*</span></label>
                                                                        <input name="persons_count" value="{{ $car->persons_count }}" type="number" class="form-control" id="persons_countfloatingInput" placeholder="person count">
                                                                    </div>
                                                                </div>
                                                                <div class="col-xxl-6 col-md-6 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="filefloatingInput">img <span class="text-danger"></span></label>
                                                                        <input name="file" type="file" id="filefloatingInput" class="form-control" placeholder="Upload Image">
                                                                    </div>
                                                                </div>  
                                                                <div class="col-xxl-6 col-md-6">
                                                                    <div class="form-group">
                                                                        <label style="margin-bottom: 7px;" for="">الدوله <span class="text-danger">*</span></label><br/>
                                                                        <select name="country_id" id="countries" class="form-control">
                                                                            <option value="{{ $car->country_id }}">{{ $car->country?->name }}</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        
                                                        <!--end tab-pane-->
                                                        <div class="tab-pane" id="arLang" role="tabpanel">
                                                            <div class="row g-2">
                                                                <div class="col-xxl-6 col-md-6 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput">name ar <span class="text-danger"></span></label>
                                                                        <input name="name[ar]" value="{{ $car->translate('ar')->name ?? '' }}" type="text" class="form-control" id="namefloatingInput" placeholder="name ar">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        
                                                        <!--end tab-pane-->
                                                        <div class="tab-pane" id="frLang" role="tabpanel">
                                                            <div class="row g-2">
                                                                <div class="col-xxl-6 col-md-6 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput">name fr <span class="text-danger"></span></label>
                                                                        <input name="name[fr]" value="{{ $car->translate('fr')->name ?? '' }}" type="text" class="form-control" id="namefloatingInput" placeholder="name ar">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        
                                                        <!--end tab-pane-->
                                                        <div class="tab-pane" id="trLang" role="tabpanel">
                                                            <div class="row g-2">
                                                                <div class="col-xxl-6 col-md-6 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput">name tr <span class="text-danger"></span></label>
                                                                        <input name="name[tr]" value="{{ $car->translate('tr')->name ?? '' }}" type="text" class="form-control" id="namefloatingInput" placeholder="name ar">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        
                                                        <!--end tab-pane-->
                                                        <div class="tab-pane" id="hiLang" role="tabpanel">
                                                            <div class="row g-2">
                                                                <div class="col-xxl-6 col-md-6 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput">name hi <span class="text-danger"></span></label>
                                                                        <input name="name[hi]" value="{{ $car->translate('hi')->name ?? '' }}" type="text" class="form-control" id="namefloatingInput" placeholder="name ar">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    
                                                        <!--end tab-pane-->
                                                        <div class="tab-pane" id="attributes" role="tabpanel">
                                                            <div class="row g-2">
                                                                <div class="col-xxl-12 col-md-12">
                                                                    <button class="btn btn-primary mb-1" id="add-input-attributes" type="button" style="background: #2f6bb9;"><i class="bx bx-plus"></i> Attributes</button>
                                                                </div>
                                                                <div class="col-xxl-6 col-md-6">
                                                                    <div id="attributes-area">
                                                                        
                                                                        @if (count($car->attributes) > 0 && $car->attributes[0] !== '')
                                                                            @foreach ($car->attributes as $index => $attribute)
                                                                                <div class="input-container mb-1 input-container-attribute-{{ $index }}">
                                                                                    <div class="row">
                                                                                        <div class="col-xxl-10 col-md-10">
                                                                                            <div class="form-floating">
                                                                                                <input name="attributes[]" value="{{ $attribute }}" type="text" class="form-control" id="namefloatingInput" placeholder="attribute">
                                                                                                <label for="namefloatingInput">attribute <span class="text-danger"></span></label>
                                                                                            </div>
                                                                                        </div>
                                                                                        <div class="col-xxl-2 col-md-2">
                                                                                            <label for="" class="mb-2"></label>
                                                                                            <span class="remove-btn badge bg-danger rounded-pill mt-4" parent-class="input-container-attribute-{{ $index }}"><i class="bx bx-trash"></i></span>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            @endforeach
                                                                        @endif

                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-12">
                                                <button class="btn btn-primary" type="submit">Submit form</button>
                                            </div>

                                        </div>
                                    </div>
                                </form>
                            @endisset
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

@endsection

<!-- custom js -->
@section('script')
<script>
    (function () {
        $('.nav-link.menu-link').removeClass('active');
        $('.menu-dropdown').removeClass('show');
        $('.sidebarcars').addClass('active');
        var target = $('.sidebarcars').attr('href');
        $(target).addClass('show');
    })();
    $('#countries').select2({
        ajax: {
            url: "{{ route('get/countries') }}",
            dataType: 'json',
            processResults: function (data) {
                return {
                    results:  $.map(data, function (item) {
                        return {
                            id: item.id,
                            text: item.name
                        }
                    })
                };
            },
            cache: true,
            width: '100%'
        }
    });
    $('#users').select2({
        ajax: {
            url: "{{ route('get/users') }}",
            dataType: 'json',
            processResults: function (data) {
                return {
                    results:  $.map(data, function (item) {
                        return {
                            id: item.id,
                            text: item.name
                        }
                    })
                };
            },
            cache: true,
            width: '100%'
        }
    });
    $('#captains').select2({
        ajax: {
            url: "{{ route('get/captains') }}",
            dataType: 'json',
            processResults: function (data) {
                return {
                    results:  $.map(data, function (item) {
                        return {
                            id: item.id,
                            text: item.name
                        }
                    })
                };
            },
            cache: true,
            width: '100%'
        }
    });
    
    var inputCount = 1000000000;
    $('#add-input-attributes').click(function () {

        inputCount++;
        $('#attributes-area').append(`
            <div class="input-container input-container-attribute-${inputCount} mb-1">
                <div class="row">
                    <div class="col-xxl-10 col-md-10">
                        <div class="form-floating">
                            <input name="attributes[]" type="text" class="form-control" id="namefloatingInput" placeholder="attributes">
                            <label for="namefloatingInput">attribute <span class="text-danger"></span></label>
                        </div>
                    </div>
                    <div class="col-xxl-2 col-md-2">
                        <label for="" class="mb-2"></label>
                        <span class="remove-btn badge bg-danger rounded-pill mt-4" parent-class="input-container-attribute-${inputCount}"><i class="bx bx-trash"></i></span>
                    </div>
                </div>
            </div>
        `);
    }); 
</script>
@endsection
