<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('destination_translations', function (Blueprint $table) {
            $table->increments('id');

            $table->unsignedBigInteger('destination_id');
            $table->string('locale')->index();
            
            $table->string('name', 255)->nullable();
            $table->string('info', 1200)->nullable();
            $table->string('location', 1200)->nullable(); 
        
            $table->unique(['destination_id', 'locale']);
            $table->foreign('destination_id')->references('id')->on('destinations')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('destination_translations');
    }
};
