<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class WalletTransaction extends Model
{
    protected $table = 'wallet_transactions';
	protected $fillable = [
		'orderable_id',
		'orderable_type',
		'wallet_id', 
		'chat_group_id',
		'amount', 
		'description', 
		'user_id', 
		'transfer_from_id', 
		'type', 
		'confirm_withdraw_by', 
		'status',
		'provider_id', 
		'payment_method_types', 
		'getway_transaction_id', 
	];
    public $timestamps = true;

	public function scopeActive($query){
		return $query->where('is_activate', 1);
	}
	
	public function scopeUnActive($query){
		return $query->where('is_activate', 0);
	}

	public function scopeArchive($query){
		return $query->whereNotNull('deleted_at');
	}
	
	public function scopeUnArchive($query){
		return $query->whereNull('deleted_at');
	}
	
	public function fildes(){
		return [
			'wallet_id' => '', 
			'chat_group_id' => '',
			'amount' => '', 
			'description' => '', 
			'user_id' => '', 
			'transfer_from_id' => '', 
			'type' => '', 
			'status' => '', 
			'provider_id' => '', 
		];
	}

	public function scopeModelSearch($model, $query)
	{
		return $model->latest()->where('id', 'LIKE', '%'. $query .'%')
					 ->orWhere('name', 'LIKE', '%'. $query .'%')
					 ->limit(PAGINATION_COUNT);
	}

	public function scopeModelSearchInArchives($model, $query)
	{
		return $model->latest()->where('id', 'LIKE', '%'. $query .'%')
					 ->orWhere('name', 'LIKE', '%'. $query .'%')
					 ->limit(PAGINATION_COUNT);
	}

	public function model_relations()
	{
		return [];
	}

	public function model_relations_counts()
	{
		return [];
	}

	public function wallet()
	{
		return $this->belongsTo(Wallet::class, 'wallet_id');
	}

	public function user()
	{
		return $this->belongsTo(User::class, 'user_id');
	}

	public function orderable()
    {
        return $this->morphTo();
    }

}