<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Astrotomic\Translatable\Contracts\Translatable as TranslatableContract;
use Astrotomic\Translatable\Translatable;
use Carbon\Carbon;

class Room extends Model implements TranslatableContract
{
    use Translatable;
    protected $table = 'rooms';
	protected $fillable = [
		'hotel_id',
		'owner_id',
		'room_type_id', 
		'room_count',
		'person_count',
		'price',
		'img',
	];
    public $timestamps = true;
	public $useTranslationFallback = true;
	public $translatedAttributes = ['info'];

	public function scopeActive($query){
		return $query->where('is_activate', 1);
	}
	
	public function scopeUnActive($query){
		return $query->where('is_activate', 0);
	}

	public function scopeArchive($query){
		return $query->whereNotNull('deleted_at');
	}
	
	public function scopeUnArchive($query){
		return $query->whereNull('deleted_at');
	}
	
	public function fildes(){
		return [
			'hotel_id' => '', 
			'owner_id' => '', 
			'room_type_id' => '', 
			'room_count' => '',
			'person_count' => '',
			'price' => '',
			'img' => '',
		];
	}

	public function scopeModelSearch($model, $query)
	{
		return $model->latest()->where('id', 'LIKE', '%'. $query .'%')
					//  ->orWhere('info', 'LIKE', '%'. $query .'%')
					 ->limit(PAGINATION_COUNT);
	}

	public function scopeModelSearchInArchives($model, $query)
	{
		return $model->latest()->where('id', 'LIKE', '%'. $query .'%')
					//  ->orWhere('info', 'LIKE', '%'. $query .'%')
					 ->limit(PAGINATION_COUNT);
	}

	public function model_relations()
	{
		return [];
	}

	public function model_relations_counts()
	{
		return [];
	}

	public function orders()
	{
		return $this->hasMany(HotelOrder::class, 'room_id');
	}

	public function hotel()
	{
		return $this->belongsTo(Hotel::class, 'hotel_id');
	}

	public function room_type()
	{
		return $this->belongsTo(RoomType::class, 'room_type_id');
	}

	public function options()
	{
		return $this->belongsToMany(Option::class, 'room_options');
	}

	public function hasConflict(Carbon $start, Carbon $end, $ignoreOrderId = null): bool
	{
		return $this->orders()->when($ignoreOrderId, fn($q) => $q->where('id', '!=', $ignoreOrderId))
			->whereNull('deleted_at')->where(function ($q) use ($start, $end) {
				$q->whereRaw('TIMESTAMP(date_arrive, time_arrive) < ?', [$end->format('Y-m-d H:i:s')])
				->whereRaw('TIMESTAMP(date_departure, time_departure) > ?', [$start->format('Y-m-d H:i:s')]);
			})->count();
	}

	public function overlapsCount(Carbon $start, Carbon $end, ?int $ignoreOrderId = null): int
	{
		return $this->orders()->when($ignoreOrderId, fn($q) => $q->where('id', '!=', $ignoreOrderId))
			->whereNull('deleted_at')
			->whereRaw('TIMESTAMP(date_arrive, time_arrive) < ?', [$end->format('Y-m-d H:i:s')])
			->whereRaw('TIMESTAMP(date_departure, time_departure) > ?', [$start->format('Y-m-d H:i:s')])
			->count();
	}

}