<?php

namespace App\Http\ServicesLayer\FairbaseServices;

use Illuminate\Support\Facades\Http;
// use Google\Auth\Credentials\ServiceAccountCredentials;
use Google\Client as GoogleClient;

class FairbaseService
{
    public function pushNotification(string $deviceToken, string $title, string $body, string $action_type, string $target_id)
    {

        $firebaseData = $this->getFirebaseData();
        $projectId = $firebaseData['projectId']; 
        $accessToken = $firebaseData['accessToken'];
        
        if ($deviceToken == 'all') {
            $key = 'topic'; 
            $value = 'all';
        } elseif ($deviceToken == 'chat') {
            $key = 'topic'; 
            $value = "chat_group_$target_id";
        } else {
            $key = 'token';
            $value = $deviceToken;
        }
        $payload = [
            'message' => [
                $key => $value,
                // 'topic' => 'all',
                // 'token' => $deviceToken,
                // 'token' => "eS93IYedo0EXr6_htZu5ZQ:APA91bFqoMg61yrHdGMYcAXyY0248kipSG6kFrscY6kqlEjm6_gJkAHzAlYvhIUKERHzGYpu9KuUtWq3cHhWoyyK_lNi8gRhfhDVmK3bXdAZB6wowTsX7Rg",
                'notification' => [
                    'title' => $title,
                    'body'  => $body,
                ],
                'data' => [
                    'target_id'  => $target_id,
                    'action_type'  => $action_type,
                    'click_action' => 'FLUTTER_NOTIFICATION_CLICK',
                ],
            ],
        ];
        $response = Http::withToken($accessToken)->post("https://fcm.googleapis.com/v1/projects/{$projectId}/messages:send", $payload);  
        return $response->json();

    }

    public function getFirebaseData()
    {
        $credentialsPath = base_path('app/Http/ServicesLayer/FairbaseServices/tripooo-34420-firebase-adminsdk-fbsvc-61b58d82c1.json');
        $credentials = json_decode(file_get_contents($credentialsPath), true);
        $response['projectId'] = $credentials['project_id'];    
        
        $client = new GoogleClient();
        $client->setAuthConfig($credentialsPath); 
        $client->addScope('https://www.googleapis.com/auth/firebase.messaging'); 
        $token = $client->fetchAccessTokenWithAssertion();
        $response['accessToken'] = $token['access_token'];
        return $response;
    }

    public function saveChatMessage($message, ?string $actionType = null, ?string $targetId = null, ?string $fcm_token = null): array 
    {
        $payload = [
            'id'              => $message['id'],
            'text'            => $message['message'],
            'file'            => $message['file'],
            'message_type'    => $message['message_type'],
            'sender_id'       => $message['added_by_id'],
            'group_id'        => $message['group_id'],
            'target_id'       => $message['group_id'],
            'action_type'     => $actionType,
            'created_at'      => now()->toISOString(),
            'created_ts'      => now()->timestamp,
        ];
        $resp = Http::post('https://tripooo-34420-default-rtdb.asia-southeast1.firebasedatabase.app/' . "chats/group_{$message['group_id']}/messages.json", $payload);
        if ($resp->failed()) {
            return [
                'ok'     => false,
                'error'  => [
                    'status' => $resp->status(),
                    'body'   => $resp->body(),
                ],
            ];
        }
        $data = $resp->json();
        $autoKey = $data['name'] ?? null;

        Http::put('https://tripooo-34420-default-rtdb.asia-southeast1.firebasedatabase.app/' . "chats/group_{$message['group_id']}/last.json", $payload)->throw();
        return [
            'ok' => true,
            'key' => $autoKey,
            'message' => $payload,
        ];

    }


    // public function pushNotification(string $deviceToken, string $title, string $body, string $action_type, string $target_id)
    // {
            
    //     "eS93IYedo0EXr6_htZu5ZQ:APA91bFqoMg61yrHdGMYcAXyY0248kipSG6kFrscY6kqlEjm6_gJkAHzAlYvhIUKERHzGYpu9KuUtWq3cHhWoyyK_lNi8gRhfhDVmK3bXdAZB6wowTsX7Rg",
    //     "cXmf-bClTg68yTEcnujtvu:APA91bFQ9uDF3lki7GPv2xaA73187SLjdsvP8hOs2c5hBsMbvLULn7Tvp2PMRSVmJlmEkkB9AWaCp-apPbLS_mUezF2pIfOuhg20Ic8J6m46TCP4M5Kl91M"
    //     $firebaseData = $this->getFirebaseData();
    //     $accessToken = $firebaseData['accessToken'];
    //     $url = $firebaseData['url'];

    //     $payload = [
    //         'message' => [
    //             'token' => $deviceToken,
    //             // 'topic' => 'all',
    //             'notification' => [
    //                 'title' => $title,
    //                 'body'  => $body,
    //             ],
    //             'data' => [ 
    //                 'target_id'  => $target_id,
    //                 'action_type'  => $action_type,
    //                 'click_action' => 'FLUTTER_NOTIFICATION_CLICK',
    //             ],
    //         ],
    //     ];
    //     $response = Http::withHeaders([
    //         'Authorization' => "Bearer $accessToken",
    //         'Content-Type' => 'application/json',
    //     ])->post($url, $payload);
    
    //     return $response->json();
    // }

    // public function getFirebaseData()
    // {
    //     $credentialsPath = base_path('app\Http\ServicesLayer\FairbaseServices\albhkaly-eeacd-firebase-adminsdk-fbsvc-dcea3ee0b0.json');
    //     $scopes = ['https://www.googleapis.com/auth/firebase.messaging'];
    //     $credentials = new ServiceAccountCredentials($scopes, $credentialsPath);
    //     $tokenData = $credentials->fetchAuthToken();
    //     $projectId = json_decode(file_get_contents($credentialsPath), true)['project_id'];
    //     $response['accessToken'] = $tokenData['access_token'];
    //     $response['url'] = "https://fcm.googleapis.com/v1/projects/{$projectId}/messages:send";
    //     return $response;
    // }
}

