<?php

namespace App\Http\Requests\Admin\HotelRequests;

use Illuminate\Foundation\Http\FormRequest;

class HotelStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name.en' => 'required|string|max:254|unique:hotel_translations,name,NULL,id,locale,en',
            'name.ar' => 'nullable|string|max:254|unique:hotel_translations,name,NULL,id,locale,ar',
            'name.fr' => 'nullable|string|max:254|unique:hotel_translations,name,NULL,id,locale,fr',
            'name.tr' => 'nullable|string|max:254|unique:hotel_translations,name,NULL,id,locale,tr',
            'name.hi' => 'nullable|string|max:254|unique:hotel_translations,name,NULL,id,locale,hi',
            
            'info.en' => 'required|string|max:254',
            'info.ar' => 'nullable|string|max:254',
            'info.fr' => 'nullable|string|max:254',
            'info.tr' => 'nullable|string|max:254',
            'info.hi' => 'nullable|string|max:254',
            
            'location.en' => 'required|string|max:254',
            'location.ar' => 'nullable|string|max:254',
            'location.fr' => 'nullable|string|max:254',
            'location.tr' => 'nullable|string|max:254',
            'location.hi' => 'nullable|string|max:254',
            
            'file' => 'required|image|mimes:jpeg,png,jpg,gif',
            'day_price' => 'required',
            'offer' => 'nullable',
            'map_location' => 'required|string|max:1200',
            'country_id' => 'required|exists:countries,id',
            'owner_id' => 'nullable|exists:users,id',
            
            'albums' => 'nullable|array',
            'albums.*' => 'required|image|max:10000',
            
            // 'rooms' => 'required|array',
            // 'rooms.*.room' => 'required|string|max:255',
            // 'rooms.*.price' => 'required|min:1',
            
            'attributes' => 'nullable|array',
            'attributes.*' => 'required|string|max:100',
            
            // 'location' => 'required|string|max:1200',
            // 'name' => 'required|string|max:254|unique:hotels,name',
            // 'info' => 'required|string|max:1200',
        ];
    }
}
