<?php

namespace App\Http\Requests\Admin\CarRequests;

use Illuminate\Foundation\Http\FormRequest;

class CarStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name.en' => 'required|string|max:254|unique:restaurant_translations,name,NULL,id,locale,en',
            'name.ar' => 'nullable|string|max:254|unique:restaurant_translations,name,NULL,id,locale,ar',
            'name.fr' => 'nullable|string|max:254|unique:restaurant_translations,name,NULL,id,locale,fr',
            'name.tr' => 'nullable|string|max:254|unique:restaurant_translations,name,NULL,id,locale,tr',
            'name.hi' => 'nullable|string|max:254|unique:restaurant_translations,name,NULL,id,locale,hi',
            
            'file' => 'required|image|mimes:jpeg,png,jpg,gif',
            'price' => 'required|max:255',
            'offer' => 'nullable|max:255',
            // 'mobile' => 'required|max:255',
            'persons_count' => 'required|max:255',
            // 'owner' => 'required|string|max:255',
            'country_id' => 'required|exists:countries,id',
            'owner_id' => 'nullable|exists:users,id',
            
            'attributes' => 'nullable|array',
            'attributes.*' => 'required|string|max:100',
        ];
    }
}
