<?php

namespace App\Http\Repositories\Eloquent\Admin;

use App\Models\Hotel;
use App\Models\Room;
use DevxPackage\AbstractRepository;

class RoomRepository extends AbstractRepository
{

    protected $model;
    protected $hotel;

    public function __construct(Room $model, Hotel $hotel)
    {
        $this->model = $model;
        $this->hotel = $hotel;
    }

    public function crudName(): string
    {
        return 'rooms';
    }

    public function index($offset, $limit)
    {
        $rooms = $this->pagination($offset, $limit);
        return view('admin.rooms.index', compact('rooms'));
    }

    public function store($request)
    {
        $request->merge(['owner_id' => auth()->user()->id]);
        $translations = [];
        foreach (config('translatable.locales') as $locale) {
            $data = [];
            if (!empty($request->input("info.$locale")))    $data['info'] = $request->input("info.$locale");
            if (!empty($data)) {
                $translations[$locale] = $data;
            }
        }
        $options = $request['options'] ?? null;
        $request = $this->handle_request($request);
        $model = $this->model->create($request);
        if (isset($options)) {
            $model->options()->sync($options);
        }
        if (!empty($translations)) {
            $model->update($translations);
        }
        return $model;
    }
    
    public function update($request, $id)
    {
        $model = $this->model->where("id", $id)->first();
        $translations = [];
        foreach (config('translatable.locales') as $locale) {
            $data = [];
            if (!empty($request->input("info.$locale")))    $data['info'] = $request->input("info.$locale");
            if (!empty($data)) {
                $translations[$locale] = $data;
            }
        }
        $options = $request['options'] ?? null;
        $request = $this->handle_request($request);
        $model->update($request);
        if (isset($options)) {
            $model->options()->sync($options);
        }
        if (!empty($translations)) {
            $model->update($translations);
        }
        return $model;
    }

    public function pagination($offset, $limit)
    {
        return $this->model->with($this->model->model_relations())->withCount($this->model->model_relations_counts())->unArchive()->orderBy('id', 'DESC')->paginate(PAGINATION_COUNT);
    }

    public function create()
    {
        return view('admin.rooms.create');
    }

    public function edit($id)
    {
        $room = $this->findOne($id);
        return view('admin.rooms.update', compact('room'));
    }

    public function archivesPage($offset, $limit)
    {
        $rooms = $this->archives($offset, $limit);
        return view('admin.rooms.archives', compact('rooms'));
    }

}