<?php

namespace App\Http\Repositories\Eloquent\Admin;

use App\Models\Language;
use DevxPackage\AbstractRepository;

class LanguageRepository extends AbstractRepository
{

    protected $model;

    public function __construct(Language $model)
    {
        $this->model = $model;
    }

    public function crudName(): string
    {
        return 'languages';
    }

    public function index($offset, $limit)
    {
        $languages = $this->pagination($offset, $limit);
        return view('admin.languages.index', compact('languages'));
    }

    public function pagination($offset, $limit)
    {
        return $this->model->with($this->model->model_relations())->withCount($this->model->model_relations_counts())->unArchive()->orderBy('id', 'DESC')->paginate(PAGINATION_COUNT);
    }

    public function create()
    {
        return view('admin.languages.create');
    }

    public function store($request)
    {
        $model = new $this->model();
        foreach (config('translatable.locales') as $locale) {
            $name = $request->input("name.$locale");
            // $desc = $request->input("description.$locale");

            if (!empty($name)) {
                $model->translateOrNew($locale)->name = $name;
            }    
            // if (!empty($desc)) {
            //     $model->translateOrNew($locale)->description = $desc;
            // }
        }
        $model->save();        
        return $model;
    }

    public function edit($id)
    {
        $language = $this->findOne($id);
        return view('admin.languages.update', compact('language'));
    }
    
    public function update($request, $id)
    {
        $model = $this->model->where('id', $id)->first();
        $model->deleteTranslations();
        foreach (config('translatable.locales') as $locale) {
            $name = $request->input("name.$locale");
            if (!empty($name)) {
                $model->translateOrNew($locale)->name = $name;
            }
        }
        $model->save();        
        return $model;
    }

    public function archivesPage($offset, $limit)
    {
        $languages = $this->archives($offset, $limit);
        return view('admin.languages.archives', compact('languages'));
    }

    public function customSearch($request)
    {
        $query = $request->get('q');
        $records = [];
        
        if( !is_null($query) ){
            $searchButton = 0;
            $records = $this->model->with($this->model->model_relations())->withCount($this->model->model_relations_counts())->unArchive()->modelSearch($query)->get();
        }else{
            $searchButton = 1;
            $records = $this->model->latest()->with($this->model->model_relations())->withCount($this->model->model_relations_counts())->unArchive()->limit(PAGINATION_COUNT)->get(); 
        }
        
        if($records && count($records) > 0){
            $records[0]->searchButton = $searchButton;
        }
        return $records;
    }

}