<?php

namespace App\Http\Repositories\Eloquent\Admin;

use App\Models\Hotel;
use App\Models\HotelOrder;
use DevxPackage\AbstractRepository;

class HotelRepository extends AbstractRepository
{

    protected $model;
    protected $hotelOrder;

    public function __construct(Hotel $model, HotelOrder $hotelOrder)
    {
        $this->model = $model;
        $this->hotelOrder = $hotelOrder;
    }

    public function crudName(): string
    {
        return 'hotels';
    }

    public function index($offset, $limit)
    {
        return $this->pagination($offset, $limit);
    }

    public function pagination($offset, $limit)
    {
        return $this->model->with($this->model->model_relations())->withCount($this->model->model_relations_counts())->unArchive()->orderBy('id', 'DESC')->paginate(PAGINATION_COUNT);
    }

    public function create()
    {
        return view('admin.hotels.create');
    }

    public function store($request)
    {
        $translations = [];
        $model = new $this->model();
		$model->day_price = (int)$request->day_price ?? 0;
		$model->offer = (int)$request->offer ?? 0;
		$model->map_location = $request->map_location;
		$model->country_id = $request->country_id ?? null;
		$model->owner_id = $request->owner_id ?? null;
        foreach (config('translatable.locales') as $locale) {
            $data = [];
            if (!empty($request->input("name.$locale")))    $data['name'] = $request->input("name.$locale");
            if (!empty($request->input("info.$locale")))    $data['info'] = $request->input("info.$locale");
            if (!empty($request->input("location.$locale")))    $data['location'] = $request->input("location.$locale");
            if (!empty($data)) {
                $translations[$locale] = $data;
            }
        }
        if (!$request->hasFile('file') == null) {
            $model->img = uploadIamge($request->file('file'), $this->crudName());
        }
        if ($request->input('attributes') !== null && count($request->input('attributes')) > 0) {
            $attributes = [];
            foreach ($request->input('attributes') as $attribute) {
                $attributes [] = $attribute;
            }
            $model->attributes = implode(',', $attributes);
        }
		$model->albums = isset($request['albums']) ? uploadIamges($request['albums'], $this->crudName()) : null;
        $model->save();
        // $rooms = [];
        // foreach ($request->rooms as $room) {
        //     $rooms [] = [
        //         'created_at' => now(),
        //         'updated_at' => now(),
        //         'room' => $room['room'], 
        //         'price' => $room['price'], 
        //         'hotel_id' => $model->id,
        //     ];
        // }
        // if (count($rooms) > 0) {
        //     $model->rooms()->insert($rooms);
        // }
        $model->update($translations);
        return $model;
    }

    public function edit($id)
    {
        $hotel = $this->findOne($id);
        // dd($hotel);
        return view('admin.hotels.update', compact('hotel'));
    }
    
    public function update($request, $id)
    {
        $translations = [];
        $model = $this->model->where('id', $id)->first();
		$model->day_price = (int)$request->day_price ?? 0;
		$model->offer = (int)$request->offer ?? 0;
		$model->map_location = $request->map_location;
		$model->country_id = $request->country_id ?? null;
		$model->owner_id = $request->owner_id ?? $model->owner_id;
        $model->deleteTranslations();
        foreach (config('translatable.locales') as $locale) {
            $data = [];
            if (!empty($request->input("name.$locale")))    $data['name'] = $request->input("name.$locale");
            if (!empty($request->input("info.$locale")))    $data['info'] = $request->input("info.$locale");
            if (!empty($request->input("location.$locale")))    $data['location'] = $request->input("location.$locale");
            if (!empty($data)) {
                $translations[$locale] = $data;
            }
        }
        if (!$request->hasFile('file') == null) {
            $model->img = uploadIamge($request->file('file'), $this->crudName());
        }
        if ($request->input('attributes') !== null && count($request->input('attributes')) > 0) {
            $attributes = [];
            foreach ($request->input('attributes') as $attribute) {
                $attributes [] = $attribute;
            }
            $model->attributes = implode(',', $attributes);
        }
        if (isset($request->albums)) {
            $albums = uploadIamges($request->albums, $this->crudName());
            $model->albums = is_null($model->albums) ? $albums : implode(',', $model->albums) .','. $albums;
        }
        $model->save();
        // if (isset($request->rooms) && count($request->rooms) > 0) {
        //     $rooms = [];
        //     foreach ($request->rooms as $room) {
        //         $rooms [] = [
        //             'created_at' => now(),
        //             'updated_at' => now(),
        //             'room' => $room['room'], 
        //             'price' => $room['price'], 
        //             'hotel_id' => $model->id,
        //         ];
        //     }
        //     $model->rooms()->delete();
        //     $model->rooms()->insert($rooms);
        // }
        $model->update($translations);
        return $model;
    }

    public function archivesPage($offset, $limit)
    {
        $hotels = $this->archives($offset, $limit);
        return view('admin.hotels.archives', compact('hotels'));
    }
    
    public function uploadAlbums($request, $id)
    {
        $model = $this->model->where('id', $id)->first();
        if ($request->hasFile('file')) {
            $file = uploadIamge($request->file('file'), $this->crudName());
            $oldImages = $model->albums ? explode(',', $model->albums) : [];
            $oldImages[] = $file;
            $model->albums = implode(',', $oldImages);
            $model->save();
            return response()->json(['success' => true]);
        }
        return response()->json(['error' => 'No file uploaded'], 400);
    }

    public function deleteImg($request, $id)
    {
        $model = $this->model->where('id', $id)->first();
        if ($request->input('img_name')) {
            $imageToDelete = $request->input('img_name');
            $oldImages = $model->albums ? explode(',', $model->albums) : [];
            $filteredImages = array_filter($oldImages, function($img) use ($imageToDelete) {
                return trim($img) !== ltrim(trim($imageToDelete), '/');
            });
            $model->albums = implode(',', $filteredImages);
            $model->save();
            if (file_exists(public_path($imageToDelete))) {
                unlink(public_path($imageToDelete));
            }
            return response()->json(['success' => true]);
        }
        return response()->json(['error' => 'No file uploaded'], 400);
    }

    public function orders($offset, $limit)
    {
        return $this->hotelOrder->with($this->hotelOrder->model_relations())->unArchive()->orderBy('id', 'DESC')->paginate(PAGINATION_COUNT);
    }

}