<?php

namespace App\Http\Repositories\Eloquent\Admin;

use App\Models\ChatGroup;
use DevxPackage\AbstractRepository;

class GroupRepository extends AbstractRepository
{

    protected $model;

    public function __construct(ChatGroup $model)
    {
        $this->model = $model;
    }

    public function crudName(): string
    {
        return 'groups';
    }

    public function index($offset, $limit)
    {
        $groups = $this->pagination($offset, $limit);
        return view('admin.groups.index', compact('groups'));
    }

    public function pagination($offset, $limit)
    {
        return $this->model->with($this->model->model_relations())->withCount($this->model->model_relations_counts())->unArchive()->orderBy('id', 'DESC')->paginate(PAGINATION_COUNT);
    }

    public function create()
    {
        return view('admin.groups.create');
    }

    public function edit($id)
    {
        $group = $this->findOne($id);
        return view('admin.groups.update', compact('group'));
    }

    public function archivesPage($offset, $limit)
    {
        $groups = $this->archives($offset, $limit);
        return view('admin.groups.archives', compact('groups'));
    }

    public function handle_update_request($request)
    {
        $request->password ? $request->merge(['password' => bcrypt($request->password)]) : "";
        if (!$request->hasFile('file') == null) {
            $file = uploadIamge($request->file('file'), $this->crudName()); // function on helper file to upload file
            $request->merge(['img' => $file]);
        }
        if (!$request->hasFile('files') == null) {
            $files = uploadIamges($request->file('files'), $this->crudName()); // function on helper file to upload file
            $request->merge(['imgs' => $files]);
        }
        $request = array_filter(array_intersect_key($request->all(), $this->model->updateFildes()));
        return $request;
    }

}