<?php

namespace App\Http\Repositories\Eloquent\Admin;

use App\Models\Country;
use DevxPackage\AbstractRepository;

class CountryRepository extends AbstractRepository
{

    protected $model;

    public function __construct(Country $model)
    {
        $this->model = $model;
    }

    public function crudName(): string
    {
        return 'countries';
    }

    public function index($offset, $limit)
    {
        $countries = $this->pagination($offset, $limit);
        return view('admin.countries.index', compact('countries'));
    }

    public function pagination($offset, $limit)
    {
        return $this->model->with($this->model->model_relations())->withCount($this->model->model_relations_counts())->unArchive()->orderBy('id', 'DESC')->paginate(PAGINATION_COUNT);
    }

    public function create()
    {
        return view('admin.countries.create');
    }

    public function edit($id)
    {
        $country = $this->findOne($id);
        return view('admin.countries.update', compact('country'));
    }

    public function archivesPage($offset, $limit)
    {
        $countries = $this->archives($offset, $limit);
        return view('admin.countries.archives', compact('countries'));
    }

}