<?php

namespace App\Http\Repositories\Eloquent\Admin;

use App\Models\Car;
use App\Models\CarOrder;
use DevxPackage\AbstractRepository;

class CarRepository extends AbstractRepository
{

    protected $model;
    protected $carOrder;

    public function __construct(Car $model, CarOrder $carOrder)
    {
        $this->model = $model;
        $this->carOrder = $carOrder;
    }

    public function crudName(): string
    {
        return 'cars';
    }

    public function index($offset, $limit)
    {
        return $this->pagination($offset, $limit);
    }

    public function pagination($offset, $limit)
    {
        return $this->model->with($this->model->model_relations())->withCount($this->model->model_relations_counts())->unArchive()->orderBy('id', 'DESC')->paginate(PAGINATION_COUNT);
    }

    public function create()
    {
        return view('admin.cars.create');
    }

    public function store($request)
    {
        $translations = [];
        $model = new $this->model();
        $model->price = (int)$request->price ?? 0;
        $model->offer = (int)$request->offer ?? 0;
        $model->captain_id = $request->captain_id;
        $model->mobile = $request->mobile;
        $model->persons_count = $request->persons_count;
		$model->country_id = $request->country_id ?? null;
        // $model->owner = $request->owner;
		$model->owner_id = $request->owner_id ?? null;
        foreach (config('translatable.locales') as $locale) {
            $data = [];
            if (!empty($request->input("name.$locale")))    $data['name'] = $request->input("name.$locale");
            if (!empty($data)) {
                $translations[$locale] = $data;
            }
        }
        if (!$request->hasFile('file') == null) {
            $model->img = uploadIamge($request->file('file'), $this->crudName());
        }
        if ($request->input('attributes') !== null && count($request->input('attributes')) > 0) {
            $attributes = [];
            foreach ($request->input('attributes') as $attribute) {
                $attributes [] = $attribute;
            }
            $model->attributes = implode(',', $attributes);
        }
        $model->save();
        $model->update($translations);
        return $model;
    }

    public function edit($id)
    {
        $car = $this->findOne($id);
        return view('admin.cars.update', compact('car'));
    }
    
    public function update($request, $id)
    {
        $translations = [];
        $model = $this->model->where('id', $id)->first();
        $model->price = (int)$request->price ?? 0;
        $model->offer = (int)$request->offer ?? 0;
        $model->captain_id = $request->captain_id;
        $model->mobile = $request->mobile;
        $model->persons_count = $request->persons_count;
		$model->country_id = $request->country_id ?? null;
        // $model->owner = $request->owner;
		$model->owner_id = $request->owner_id ?? $model->owner_id;
        $model->deleteTranslations();
        foreach (config('translatable.locales') as $locale) {
            $data = [];
            if (!empty($request->input("name.$locale")))    $data['name'] = $request->input("name.$locale");
            if (!empty($data)) {
                $translations[$locale] = $data;
            }
        }
        if (!$request->hasFile('file') == null) {
            $model->img = uploadIamge($request->file('file'), $this->crudName());
        }
        if ($request->input('attributes') !== null && count($request->input('attributes')) > 0) {
            $attributes = [];
            foreach ($request->input('attributes') as $attribute) {
                $attributes [] = $attribute;
            }
            $model->attributes = implode(',', $attributes);
        }
        $model->save();
        $model->update($translations);
        return $model;
    }

    public function archivesPage($offset, $limit)
    {
        $cars = $this->archives($offset, $limit);
        return view('admin.cars.archives', compact('cars'));
    }

    public function orders($offset, $limit)
    {
        return $this->carOrder->with($this->carOrder->model_relations())->unArchive()->orderBy('id', 'DESC')->paginate(PAGINATION_COUNT);
    }

}