<?php

namespace App\Http\Repositories\Eloquent\Admin;

use App\Models\Captain;
use DevxPackage\AbstractRepository;

class CaptainRepository extends AbstractRepository
{

    protected $model;

    public function __construct(Captain $model)
    {
        $this->model = $model;
    }

    public function crudName(): string
    {
        return 'captains';
    }

    public function index($offset, $limit)
    {
        $captains = $this->pagination($offset, $limit);
        return view('admin.captains.index', compact('captains'));
    }

    public function pagination($offset, $limit)
    {
        return $this->model->with($this->model->model_relations())->withCount($this->model->model_relations_counts())->unArchive()->orderBy('id', 'DESC')->paginate(PAGINATION_COUNT);
    }

    public function create()
    {
        return view('admin.captains.create');
    }

    public function edit($id)
    {
        return back();
        $captain = $this->findOne($id);
        return view('admin.captains.update', compact('captain'));
    }

    public function archivesPage($offset, $limit)
    {
        $captains = $this->archives($offset, $limit);
        return view('admin.captains.archives', compact('captains'));
    }

}