<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SetLocale
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle($request, \Closure $next)
    {
        try {
            app()->setLocale($request->header('Accept-Language') ?? config('app.fallback_locale'));
        } catch (\Exception $ex) {
            app()->setLocale(config('app.fallback_locale'));
        }
        return $next($request);
    }
    
}
