<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\UserRequesrs\StoreGuideOrderRequest;
use App\Http\ServicesLayer\FairbaseServices\FairbaseService;
use App\Models\CafeOrder;
use App\Models\CarOrder;
use App\Models\FavorateGuide;
use App\Models\GuideOrder;
use App\Models\HotelOrder;
use App\Models\RestaurantOrder;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class ClientController extends Controller
{

    public $user;
    public $guideOrder;
    public $carOrder;
    public $hotelOrder;
    public $restaurantOrder;
    public $cafeOrder;
    public $favorateGuide;
    public $fairbaseService;

    public function __construct(
        User $user, GuideOrder $guideOrder, CarOrder $carOrder, HotelOrder $hotelOrder, RestaurantOrder $restaurantOrder, CafeOrder $cafeOrder, FairbaseService $fairbaseService
    )
    {
        $this->user = $user;
        $this->guideOrder = $guideOrder;
        $this->carOrder = $carOrder;
        $this->hotelOrder = $hotelOrder;
        $this->restaurantOrder = $restaurantOrder;
        $this->cafeOrder = $cafeOrder;
        $this->fairbaseService = $fairbaseService;
        $this->middleware('auth:api', ['except' => []]);
    }

    public function myOrders(Request $request, $offset)
    {
        try{
            $auth = auth()->user();
            switch ((int)$request->orders_type) {
                case 1:
                    $query = $this->guideOrder->where('added_by', $auth->id)->with(['guide', 'user']);
                    break;
                
                case 2:
                    $query = $this->carOrder->where('added_by', $auth->id)->with(['car', 'user']);
                    break;
                
                case 3:
                    $query = $this->hotelOrder->where('added_by', $auth->id)->with(['hotel', 'user']);
                    break;
                
                case 4:
                    $query = $this->restaurantOrder->where('added_by', $auth->id)->with(['restaurant', 'user']);
                    break;
                
                case 5:
                    $query = $this->cafeOrder->where('added_by', $auth->id)->with(['cafe', 'user']);
                    break;
                
                default:
                    return responseJson(500, 'there is some thing wrong , please contact technical support');
                    break;
            }
            $records = $query->when($request->status, function($q) use ($request) {
                $q->where('status', $request->status);
            })->orderBy('id', 'DESC')->offset($offset)->limit(PAGINATION_COUNT)->get();
            return responseJson(200, "success", $records);
        }catch(\Exception $e){
            return responseJson(500, 'there is some thing wrong , please contact technical support');
        }
    }
    
    public function orderStatus(Request $request, $id)
    {
        
        $validator = Validator::make($request->all(), [
            'status' => 'required|in:4',
            'orders_type' => 'required|in:1,2,3,4,5',
        ]);
        if ($validator->fails()) {
            return responseJson(400, "Bad Request", $validator->errors()->first());
        }

        $auth = auth()->user();
        // $order = $this->guideOrder->where('id', $id)->where('added_by', $auth->id)->with('provider')->first();
        switch ((int)$request->orders_type) {
            case 1:
                $orderAction = 1;
                $order = $this->guideOrder->where('id', $id)->where('added_by', $auth->id)->with('provider')->first();
                break;
            
            case 2:
                $orderAction = 2;
                $order = $this->carOrder->where('id', $id)->where('added_by', $auth->id)->with('provider')->first();
                break;
            
            case 3:
                $orderAction = 3;
                $order = $this->hotelOrder->where('id', $id)->where('added_by', $auth->id)->with('provider')->first();
                break;
            
            case 4:
                $orderAction = 4;
                $order = $this->restaurantOrder->where('id', $id)->where('added_by', $auth->id)->with('provider')->first();
                break;
            
            case 5:
                $orderAction = 5;
                $order = $this->cafeOrder->where('id', $id)->where('added_by', $auth->id)->with('provider')->first();
                break;
            
            default:
                return responseJson(500, 'there is some thing wrong , please contact technical support');
                break;
        }
        if ($order) {
            if ((int)$order->status == 3 || (int)$order->status == 4 || (int)$order->status == 5) {
                return responseJson(404, "this order is ended");
            }
            if ((int)$request->status == 2) {
                return responseJson(404, "this order has been confirmed , please contact the provider to cancel it.");
            }
            try{
                DB::beginTransaction();
                $order->update([
                    'status' => $request->status,
                    'canceled_by' => 2,
                ]);
                DB::commit();
                
                if ($order->provider?->fcm_token) {
                    // 1 => guides, 2 => cars, 3 => hotels, 4 => restaurants, 5 => cafes
                    $pushNotification = $this->fairbaseService->pushNotification(
                        $order->provider?->fcm_token, 'change order status', "order number #$order->id has been canceled", $orderAction, $order->id
                    );
                }
                return responseJson(200, "success");
            }catch(\Exception $e){
                DB::rollBack();
                return responseJson(404, "There is something wrong , please contact technical support");
            }
        }else{
            return responseJson(404, "Not Found");
        }
    }


}
