<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Repositories\Eloquent\Admin\HotelRepository;
use App\Http\Requests\Admin\HotelRequests\HotelStoreRequest;
use App\Http\Requests\Admin\HotelRequests\HotelUpdateRequest;

class HotelController extends Controller
{

    public $hotels;

    public function __construct(HotelRepository $hotels)
    {
        $this->hotels = $hotels;
    }

    public function index($offset, $limit)
    {
        try{
            $hotels = $this->hotels->index($offset, $limit);
            return view('admin.hotels.index', compact('hotels'));
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function create()
    {
        return $this->hotels->create();
    }

    public function store(HotelStoreRequest $request)
    {
        try{
            $this->hotels->store($request);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function edit($id)
    {
        return $this->hotels->edit($id);
    }

    public function update(HotelUpdateRequest $request, $id)
    {
        try{
            $this->hotels->update($request, $id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function activate(Request $request)
    {
        try{
            $this->hotels->activate($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function delete(Request $request)
    {
        try{
            $this->hotels->delete($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function search(Request $request)
    {
        return $this->hotels->search($request);
    }

    public function searchByColumn(Request $request)
    {
        return $this->hotels->searchByColumn($request);
    }

    public function pagination($offset, $limit)
    {
        return $this->hotels->pagination($offset, $limit);
    }

    public function archives($offset, $limit)
    {
        return $this->hotels->archivesPage($offset, $limit);
    }

    public function archivesPagination($offset, $limit)
    {
        return $this->hotels->archives($offset, $limit);
    }

    public function archivesSearch(Request $request)
    {
        return $this->hotels->archivesSearch($request);
    }

    public function archivesSearchByColumn(Request $request)
    {
        return $this->hotels->archivesSearchByColumn($request);
    }


    public function back(Request $request)
    {
        try{
            $this->hotels->back($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function uploadAlbums(Request $request, $id)
    {
        try{
            return $this->hotels->uploadAlbums($request, $id);
        }catch(\Exception $e){
            // return response()->json(['error' => $e], 400);
            return response()->json(['error' => 'There Is Something Wrong, Please Contact Technical Support'], 400);
        }
    }

    public function deleteImg(Request $request, $id)
    {
        try{
            $this->hotels->deleteImg($request, $id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function orders($offset, $limit)
    {
        try{
            $orders = $this->hotels->orders($offset, $limit);
            return view('admin.hotels.orders', compact('orders'));
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

}