<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Repositories\Eloquent\Admin\CaptainRepository;
use App\Http\Repositories\Eloquent\Admin\CountryRepository;
use App\Http\Repositories\Eloquent\Admin\GroupRepository;
use App\Http\Repositories\Eloquent\Admin\HomeRepository;
use App\Http\Repositories\Eloquent\Admin\HotelRepository;
use App\Http\Repositories\Eloquent\Admin\LanguageRepository;
use App\Http\Repositories\Eloquent\Admin\OptionRepository;
use App\Http\Repositories\Eloquent\Admin\RoomTypeRepository;
use App\Http\Repositories\Eloquent\Admin\UserRepository;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public $home;
    public $languageRepository;
    public $countryRepository;
    public $captainRepository;
    public $userRepository;
    public $groupRepository;
    public $hotelRepository;
    public $roomTypeRepository;
    public $optionRepository;

    public function __construct(
        HomeRepository $home, LanguageRepository $languageRepository, CountryRepository $countryRepository, CaptainRepository $captainRepository,
        UserRepository $userRepository, GroupRepository $groupRepository, HotelRepository $hotelRepository, RoomTypeRepository $roomTypeRepository,
        OptionRepository $optionRepository
    )
    {
        $this->home = $home;
        $this->languageRepository = $languageRepository;
        $this->countryRepository = $countryRepository;
        $this->captainRepository = $captainRepository;
        $this->userRepository = $userRepository;
        $this->groupRepository = $groupRepository;
        $this->hotelRepository = $hotelRepository;
        $this->roomTypeRepository = $roomTypeRepository;
        $this->optionRepository = $optionRepository;
    }

    public function home()
    {
        return $this->home->home();
    }

    public function languages(Request $request)
    {
        return $this->languageRepository->search($request);
    }

    public function countries(Request $request)
    {
        return $this->countryRepository->search($request);
    }

    public function captains(Request $request)
    {
        return $this->captainRepository->search($request);
    }

    public function users(Request $request)
    {
        return $this->userRepository->search($request);
    }

    public function groups(Request $request)
    {
        return $this->groupRepository->search($request);
    }

    public function hotels(Request $request)
    {
        return $this->hotelRepository->search($request);
    }

    public function room_types(Request $request)
    {
        return $this->roomTypeRepository->search($request);
    }

    public function options(Request $request)
    {
        return $this->optionRepository->search($request);
    }

}
